"""
Utility subpackage for the discrete gauge/Wilson‑loop simulation pipeline.

This package collects a handful of small modules used by ``run_simulation.py``
to construct the lattice, compute gauge potentials ``A_μ``, exponentiate
those potentials to group elements ``U_μ`` and finally measure Wilson loops.

None of the functions here are performance critical; clarity and simplicity
were prioritised so that the end‑to‑end workflow is easy to follow and
adapt.  Where possible the code mirrors the structure and naming of the
original Volume 4 pipeline from the Casimir operator project.  See the
individual module docstrings for further details.
"""

# Re‑export common entry points for convenience
from .build_lattice import main as build_lattice_main
from .compute_Amu import main as compute_Amu_main
from .compute_Umu import main as compute_Umu_main
from .measure_wilson import main as measure_wilson_main
from .plot_results import main as plot_results_main

__all__ = [
    'build_lattice_main',
    'compute_Amu_main',
    'compute_Umu_main',
    'measure_wilson_main',
    'plot_results_main',
]